# * Copyright (C) 2020 Texas Instruments Incorporated - http://www.ti.com/
#  *
#  *
#  *  Redistribution and use in source and binary forms, with or without
#  *  modification, are permitted provided that the following conditions
#  *  are met:
#  *
#  *    Redistributions of source code must retain the above copyright
#  *    notice, this list of conditions and the following disclaimer.
#  *
#  *    Redistributions in binary form must reproduce the above copyright
#  *    notice, this list of conditions and the following disclaimer in the
#  *    documentation and/or other materials provided with the
#  *    distribution.
#  *
#  *    Neither the name of Texas Instruments Incorporated nor the names of
#  *    its contributors may be used to endorse or promote products derived
#  *    from this software without specific prior written permission.
#  *
#  *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#  *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#  *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#  *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#  *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#  *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#  *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#  *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#  *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#  *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
#  *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#  *
# */


from tkinter import *
import tkinter as tk
from tkinter.ttk import *
from Start_Callback import *
from Save_Settings_Callback import *
from Load_File_Callback import *
from Menu_Callbacks import *
import global_vars


def menu_settings(self):
    # Menu Bar
    self.menu_bar = tk.Menu(self)

    # 'File' Section
    self.file_menu = Menu(self.menu_bar, tearoff=0)
    self.file_menu.add_command(label='Clear/Refresh', command=lambda: erase(self))
    self.file_menu.add_command(label='Start', state=DISABLED, command=lambda: start_option(self))
    self.file_menu.add_separator()
    self.file_menu.add_command(label='Exit', command=self.destroy)
    self.menu_bar.add_cascade(label="File", menu=self.file_menu)

    # 'View' Section
    self.view_menu = Menu(self.menu_bar, tearoff=0)
    self.view_menu.add_command(label='Read File', state=DISABLED, command=lambda: open_read_file(self))
    self.view_menu.add_command(label='Export Output Log', command=lambda: log_output(self))
    self.menu_bar.add_cascade(label="View", menu=self.view_menu)

    # 'Tools' Section
    self.tools_menu = Menu(self.menu_bar, tearoff=0)
    self.tools_menu.add_command(label='Scan for Devices', command=lambda: device_scan(self))
    self.tools_menu.add_command(label='Form Network', command=lambda: forming_network(self), state=DISABLED)
    self.tools_menu.add_command(label='Reset', command=lambda: reset_device(self), state=DISABLED)
    self.tools_menu.add_command(label='Configure Content', command=lambda: open_config_file(self))
    self.tools_menu.add_command(label='Save Settings', command=lambda: save_config(self))
    self.tools_menu.add_command(label='Load Settings', command=lambda: load_config(self))
    self.menu_bar.add_cascade(label="Tools", menu=self.tools_menu)

    # 'Help' Section
    self.help_menu = Menu(self.menu_bar, tearoff=0)
    self.help_menu.add_command(label='About', command=lambda: about(self))
    self.help_menu.add_command(label='Resources', command=lambda: resources(self))
    self.help_menu.add_command(label='Software', command=lambda: software(self))
    self.help_menu.add_command(label='How to Use', command=lambda: how_to_use(self))

    # 'NVM Regions' Section
    if not file_in_path(self, global_vars.descriptions_file):
        self.help_menu.add_command(label='NVM Regions', command=lambda: nv_index(self, global_vars.descriptions_file))
    else:
        self.Lb3.delete(0, END)
        self.Lb3.insert(END, "The file " + os.path.basename(global_vars.descriptions_file) +
                        ' was not found in the directory.')
        self.Lb3.insert(END, "Please include this file and restart the program.")
    self.menu_bar.add_cascade(label="Help", menu=self.help_menu)

    # Output the Menu Bar
    self.config(menu=self.menu_bar)
    return
